/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.views;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.google.inject.Inject;
import technology.rocketjump.undermount.rooms.RoomType;
import technology.rocketjump.undermount.rooms.RoomTypeDictionary;
import technology.rocketjump.undermount.ui.actions.RoomSelectedAction;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.skins.GuiSkinRepository;
import technology.rocketjump.undermount.ui.views.GuiView;
import technology.rocketjump.undermount.ui.views.GuiViewName;
import technology.rocketjump.undermount.ui.widgets.ButtonStyle;
import technology.rocketjump.undermount.ui.widgets.IconButton;
import technology.rocketjump.undermount.ui.widgets.IconButtonFactory;

public class RoomSelectionGuiView
implements GuiView {
    private final I18nTranslator i18nTranslator;
    private final int ROOMS_PER_ROW = 4;
    private Table viewTable;
    private Table roomTable;
    private ScrollPane scrollPane;
    private final Label headingLabel;
    private final TextButton backButton;

    @Inject
    public RoomSelectionGuiView(GuiSkinRepository guiSkinRepository, final MessageDispatcher messageDispatcher, IconButtonFactory iconButtonFactory, RoomTypeDictionary roomTypeDictionary, I18nTranslator i18nTranslator) {
        this.i18nTranslator = i18nTranslator;
        Skin uiSkin = guiSkinRepository.getDefault();
        this.viewTable = new Table(uiSkin);
        this.viewTable.background("default-rect");
        this.headingLabel = new Label((CharSequence)"Zones", uiSkin);
        this.viewTable.add(this.headingLabel).center();
        this.viewTable.row();
        this.roomTable = new Table(uiSkin);
        this.roomTable.setWidth(400.0f);
        this.roomTable.setHeight(300.0f);
        int numRoomsAdded = 0;
        for (RoomType roomType : roomTypeDictionary.getAll()) {
            if (roomType.getRoomName().equals(RoomTypeDictionary.VIRTUAL_PLACING_ROOM.getRoomName())) continue;
            IconButton iconButton = iconButtonFactory.create(roomType.getI18nKey(), roomType.getIconName(), roomType.getColor(), ButtonStyle.LARGE);
            iconButton.setAction(new RoomSelectedAction(roomType, messageDispatcher));
            this.roomTable.add(iconButton).pad(10.0f);
            if (++numRoomsAdded % 4 != 0) continue;
            this.roomTable.row();
        }
        this.scrollPane = new ScrollPane((Actor)this.roomTable, uiSkin);
        this.scrollPane.setScrollingDisabled(true, false);
        this.scrollPane.setForceScroll(false, true);
        ScrollPane.ScrollPaneStyle scrollPaneStyle = new ScrollPane.ScrollPaneStyle(uiSkin.get(ScrollPane.ScrollPaneStyle.class));
        scrollPaneStyle.background = null;
        this.scrollPane.setStyle(scrollPaneStyle);
        this.scrollPane.setFadeScrollBars(false);
        this.viewTable.add(this.scrollPane);
        this.viewTable.row();
        this.backButton = new TextButton("Back", uiSkin);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                messageDispatcher.dispatchMessage(251, (Object)GuiViewName.DEFAULT_MENU);
            }
        });
        this.viewTable.add(this.backButton).pad(10.0f).left();
    }

    @Override
    public GuiViewName getName() {
        return GuiViewName.ROOM_SELECTION;
    }

    @Override
    public void populate(Table containerTable) {
        containerTable.clear();
        containerTable.add(this.viewTable);
    }

    @Override
    public void update() {
    }

    @Override
    public void onLanguageUpdated() {
        this.headingLabel.setText(this.i18nTranslator.getTranslatedString("GUI.ZONES_LABEL"));
        this.backButton.setText(this.i18nTranslator.getTranslatedString("GUI.BACK_LABEL"));
    }
}

